CREATE TABLE [dbo].[DISCHARGE_EVN_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ENTERED_DATE] DATETIME NOT NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[BED_UID] [UNIQUEIDENTIFIER] NULL,
[VISTA_SITE_UID] [UNIQUEIDENTIFIER] NULL,
[DISCHARGED_DATE] [datetime] NULL,
[ENTERED_BY_UID] [UNIQUEIDENTIFIER] NULL,
[TYPE_OF_MOVEMENT_ID] [int] NULL,
[ADMISSION_ID] [int] NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] DATETIME NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[DISCHARGE_EVN_H] ADD CONSTRAINT [PK_DISCHARGE_EVN_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Discharge event table.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the discharge.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The bed from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date and time of the discharge.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'DISCHARGED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The person who made the discharge order.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'ENTERED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type of movement id column (concept reference)(VistA data).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The ward from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The UTC date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of discharges.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of creation.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN_H', 'COLUMN', N'ENTERED_DATE'
GO